reformat_data_include_rupture <- function(data, conditions){
  #create the empty dataframe that will be populated
  colnames <- c("time", "condition", "technical.replicate", conditions, "censored")
  new_df <- data.frame(matrix(ncol = length(colnames), nrow = 0))
  names(new_df) <- colnames
  unique_groups <- unique(data$replicate_group)
  #cycle through each unique condition, keeping technical replicates separate
  for(group in unique_groups){
    #grab just the data from current group
    group_data <- subset(data, replicate_group == group)
    #cycle through each row in the group
    for(row in 1:nrow(group_data)){
      number_new_rows_normal = group_data$dead.normal[row] 
      number_new_rows_censored = group_data$censored[row] + group_data$dead.rupture[row]
      
      new_row_normal <- c(group_data$day[row], group_data$condition[row], group_data$technical.replicate[row])
      new_row_censored <- c(group_data$day[row], group_data$condition[row], group_data$technical.replicate[row])
      #append
      for(i in unique(conditions)){
        new_row_normal <- append(new_row_normal, group_data[row, i])
        new_row_censored <- append(new_row_censored, group_data[row, i])
      }
      new_row_normal <- append(new_row_normal, 1)
      new_row_censored <- append(new_row_censored, 0)
      if(number_new_rows_normal >0){
        for(addition in 1:number_new_rows_normal){
          new_df[nrow(new_df) + 1,] <-new_row_normal
          #new_df <- rbind(new_df, new_row)
        } 
      }
      if(number_new_rows_censored >0){
        for(addition in 1:number_new_rows_censored){
          new_df[nrow(new_df) + 1,] <-new_row_censored
          #new_df <- rbind(new_df, new_row)
        } 
      }
      
    }
  }
  new_df$time <- as.numeric(new_df$time)
  new_df$censored <- as.numeric(new_df$censored)
  return(new_df)
}